# Event-Guided Consistent Video Enhancement with Modality-Adaptive Diffusion Pipeline

We present a novel framework for consistent LLVE that seamlessly integrates both RGB and event data through a modality-agnostic diffusion pipeline. Our approach guarantees high-quality reconstruction with robust temporal consistency, even in dynamic and challenging environments. 

## Environment

1. Clone the repository and create conda environment: 

    ```
    conda create -n evdiffuser python=3.10
    conda activate evdiffuser
    ```

2. Install pytorch, we recommend `Pytorch 2.5.1` with `CUDA 11.8`:

    ```
    pip3 install torch torchvision --index-url https://download.pytorch.org/whl/cu118
    ```

3. Install the requirements:

    ```
    pip install -r requirements.txt
    ```



## Finetune EVDiffuser

### Prepare Dataset

You should prepare the dataset according to the illustration in the manuscript (see Section 3.3), including three parts:
- Event-RGB pairs: SDE
- RGB only: SDSD
- Event only: V2E2V

### Training

Training can be started using the `scripts/train.sh` scripts.

### Evaluation
You should prepare the benchmark dataset according to the illustration in the manuscript (see Section 4.1), including V-SDE and V-SDSD.

Evaluation can be started using the `scripts/eval.sh` scripts.

