# VLoRA Evaluation Package

This package contains the necessary components to reproduce the VLoRA (Video Low-Rank Adaptation) results for ICLR submission.

**VLoRA**: A novel 5D Tucker decomposition approach for efficient video generation model adaptation, supporting both VideoCrafter (5D-Tucker) and AnimateDiff (2D-Tucker) backends.

## Prerequisites

**Self-contained package**: This evaluation package contains all necessary code files for inference and evaluation.

**No additional downloads required**: All inference and evaluation scripts are included in this package.

**Note**: This package is for inference only. No training data or training scripts are included.

## Environment Setup

```bash
pip install -r env/requirements.txt
```

Or using conda:
```bash
conda env create -f env/environment.yml
conda activate vlora
```

## Quick Reproduction

**Two-step reproduction**:
1. `bash scripts/infer_ad.sh` - Generate AD-2D samples
2. `bash scripts/eval_fvd_clip.sh` - Compute FVD/CLIP-T metrics

**Note**: This package contains only inference and evaluation scripts.

## Contents

- `checkpoints/`: Pre-trained VLoRA adapter weights (5D-Tucker for VC, 2D-Tucker for AD)
  - `vc5d_tucker_r4_adapters.pt`: VideoCrafter 5D-Tucker adapters (1.3M parameters)
  - `ad2d_tucker_r0_adapters.pt`: AnimateDiff 2D-Tucker adapters (6.5M parameters)
- `prompts/`: Text prompts for evaluation
- `scripts/`: Inference and evaluation scripts only
- `stats/`: Reference statistics for FVD computation

## VLoRA Technical Details

- **5D-Tucker Decomposition**: For VideoCrafter Conv3D layers (temporal_conv.conv{1..4}.{2|3})
- **2D-Tucker Decomposition**: For AnimateDiff Motion Module Linear layers
- **Parameter Efficiency**: ~1.3M parameters for VC-5D, ~6.5M for AD-2D
- **Low-Rank Adaptation**: Only adapter weights included, no base model weights

## Notes

- **Inference-only package**: No training code or data required
- Adapter checkpoints contain only the low-rank adaptation parameters
- Base model weights are not included (download separately)
- All paths are relative to the package root
- Results will be saved to `outputs/` directory
- **Reproducibility**: Reviewers can run inference and compute FVD/CLIP-T metrics