#!/usr/bin/env bash
set -e

# Minimal VLoRA Inference Script
OUT=outputs/samples
mkdir -p "$OUT"

echo "Generating samples with minimal inference..."
python inference_minimal.py \
  --backend ad \
  --checkpoint checkpoints/ad2d_tucker_r0_adapters.pt \
  --prompt "A golden retriever splashing through a shallow river at sunset" \
  --output "$OUT/sample_001.mp4" \
  --length 16 \
  --resolution 256 \
  --seed 0 \
  --steps 20 \
  --guidance 7.5

echo "Minimal inference completed!"
echo "Samples saved to: $OUT"
echo "Note: This is a placeholder implementation"
