TRAIN_SLICE=${1:-0}
NUM_TRAIN=${2:-128}
EXP_DIR="exps/train${TRAIN_SLICE}-${NUM_TRAIN}/"
echo ${TRAIN_SLICE}
echo ${NUM_TRAIN}
echo ${EXP_DIR}

mkdir ${EXP_DIR}
cp run.sh ${EXP_DIR}

python -u run_nli.py \
  --model_name_or_path roberta-base \
  --do_train \
  --do_eval \
  --train_file data/train.csv \
  --validation_file data/dev.csv \
  --max_seq_length 128 \
  --select_train_slice ${TRAIN_SLICE} \
  --select_train_num ${NUM_TRAIN}\
  --per_device_train_batch_size 32 \
  --per_device_eval_batch_size 64 \
  --learning_rate 3e-5 \
  --num_train_epochs 50 \
  --warmup_ratio 0.1 \
  --logging_strategy epoch \
  --overwrite_output_dir \
  --output_dir ${EXP_DIR}  | tee "${EXP_DIR}log.txt"
