import matplotlib.pyplot as plt
import argparse
import pickle

parser = argparse.ArgumentParser()
parser.add_argument('-d','--data', type=str, default='cifar10')
parser.add_argument('-a','--attack', type=str, default='pgd')
args = parser.parse_args()

fracs = [0.05, 0.1, 0.15, 0.2, 0.25]
folder = 'testset_results_frac'

all_lines = []
for f in fracs:
    with open(f'{folder}/{args.data}_frac_{f}_{args.attack}_plot.txt') as fp:
        all_lines.append(fp.readlines())

plot_numbers = {}
for i in range(len(all_lines[0])):
    accs = []
    for j in range(len(fracs)):
        line = all_lines[j][i]
        splits =  line.split(" ")
        overall_acc = float(splits[-1].split('\n')[0])
        method = splits[0]
        accs.append(overall_acc)
        # print(f'overall_acc for frac {j} is {overall_acc}')
    
    plot_numbers[method] = accs

with open(f'{folder}/plot_numbers_{args.data}_{args.attack}.pkl', 'wb') as f:
    pickle.dump(plot_numbers, f)

plt.figure(figsize=(7,7))
for method in plot_numbers.keys():
    plt.plot(fracs, plot_numbers[method], marker='o', label=method)
plt.legend()
plt.title(f'Data: {args.data} | Attack: {args.attack}')
plt.show()
plt.savefig(f'{folder}/plot_{args.data}_{args.attack}.png')