import pickle
import numpy as np
import torch
import os
import argparse
from copy import deepcopy
import time

parser = argparse.ArgumentParser()
parser.add_argument('-n','--num_subsets', type=int, default=10000)
args = parser.parse_args()

total_points = 10000
frac = 0.1
num_points = int(frac*total_points)
num_subsets = args.num_subsets
subsets = []

for i in range(num_subsets):
    S_inds = np.random.choice(np.arange(total_points), num_points, replace=False)
    a = np.zeros(total_points)
    a[S_inds] = 1
    subsets.append(a)

subsets_dir = 'attacked_subsets'
os.makedirs(subsets_dir, exist_ok=True)
with open(f'{subsets_dir}/random_subsets_{num_subsets}.pkl', 'wb') as fp:
    pickle.dump(subsets, fp)

