class AttackModel:
    def __init__(self, dataset):
        self.defender_loss = None
        self.reconstruction_loss = None
        self.requires_training = False
        raise NotImplementedError()
    
    def clone(self, requires_grad=False):
        """
        Only valid for traininable attack models. Return a cloned model of yourself.

        Args:
            requires_grad (bool, optional): Should the cloned attack model be trainable. Defaults to False.
        """
        raise NotImplementedError()
    
    def get_loss(self, points, labels, requires_mean=True, save_losses=False):
        """
        Only valid for traininable attack models. Get loss of attack model on the set of data points.

        Args:
            points (PyTorch Tensor): Tensor of input points
            labels (PyTorch Tensor): Tensor of corresponding labels
            requires_mean (bool, optional): If true, returns the mean else vector of pointwise losses. Defaults to True.
            save_losses (bool, optional): If true, save reconstrucion and defender losses. Defaults to False.
        """
        raise NotImplementedError()
    
    def train_on_set(self, points, labels, epochs):
        """
        Only valid for traininable attack models. Train the current attack model on the set of points, labels pair.
        
        Args:
            points (PyTorch Tensor): Tensor of input points.
            labels (PyTorch Tensor): Tensor of corresponding labels.
            epochs (int): The number of epochs for which to train. Model might have a self.epochs field.
        """
        raise NotImplementedError()
    
    def get_perturbed(self, points, labels=None):
        """
        Get the perturbed points for the given set of points

        Args:
            points (PyTorch Tensor): Tensor of input points.
            labels (PyTorch Tensor): Tensor of corresponding labels.
        """
        raise NotImplementedError()

    def indices_to_points(self, indices):
        """
        Utility function: Takes in indices and returns corresponding dataset slice.
        
        Args:
            indices (List): List of indices. Could also be a numpy array.

        Returns:
            X, Y: A slice of the dataset, indexed by the input indices. 
        """
        return self.dataset[indices]