# Octax Tutorial

This tutorial series covers all aspects of using Octax, a JAX-based CHIP-8 emulator and reinforcement learning environment suite.

## Tutorial Structure

### [01 - Quickstart Guide](01_quickstart.md)
Get up and running with Octax in minutes. Covers installation, basic environment usage, and your first RL experiments.

### [02 - Core Emulator Concepts](02_core_emulator_concepts.md)
Understanding the CHIP-8 architecture, instruction execution, and how the emulator works internally.

### [03 - Reinforcement Learning Environments](03_reinforcement_learning_environments.md)
Using Octax for RL training, understanding reward structures, and implementing training loops with JAX.

### [04 - Custom Game Environments](04_custom_game_environments.md)
Creating your own game environments, analyzing ROM files, and implementing score/termination functions.

## Prerequisites

- Python 3.8+
- JAX installed (see installation guide in quickstart)
- Basic familiarity with reinforcement learning concepts
- Understanding of Python and NumPy