# =================================================================================================#
# Description: Summarises the experimental results for the comparisons of estimators on the 
# Parkinson's telemonitoring data
# Author: Ryan Thompson
# =================================================================================================#

import CSV, DataFrames, Statistics, Pipe

# Load data
data = CSV.read("Results/parkinsons.csv", DataFrames.DataFrame)

# Summarise results for tabling
Pipe.@pipe data |>
DataFrames.groupby(_, :estimator) |>
    DataFrames.combine(_, 
        :test_loss => (x -> round(Statistics.mean(x), digits = 3)) 
            => :test_loss_mean, 
        :test_loss => (x -> round(Statistics.std(x) / sqrt(maximum(data.id)), digits = 3)) 
            => :test_loss_std,
        :test_sparsity => (x -> round(Statistics.mean(x), digits = 1)) 
            => :test_sparsity_mean,
        :test_sparsity => (x -> round(Statistics.std(x) / sqrt(maximum(data.id)), digits = 1)) 
            => :test_sparsity_std,
        )