from variable import leet_dict_decode
import re 
import string

def self10_decode(s):
    result = ''.join([char for char in s if not char.isdigit()])
    return result
def self7_decode(text):
    words = re.findall(r'\b\w+\b|\W+', text)
    result = []
    for word in words:
        if word.isalpha():  
            if len(word) > 1:
                new_word = word[1:] + word[0]
            else:
                new_word = word  
            result.append(new_word)
        else:
            result.append(word)  
    return ''.join(result)

def self6_decode(input_string):
    pass
def self5_decode(input_string):
    pass
def self4_decode(input_string):
    return input_string.replace("-1-", "")

def self3_decode(input_string):
    return input_string.replace("-2-", "")

def self2_decode(input_string):
    def process_word(word):
        if len(word) <= 3:
            return word
        letters = re.sub(r'[^a-zA-Z]', '', word)
        if len(letters) <= 3:
            return word
        middle = letters[1:-1]
        reversed_word = letters[0] + middle[::-1] + letters[-1]
        
        for char in word:
            if not char.isalpha():
                reversed_word += char
                break
        
        return reversed_word

    words = input_string.split()
    processed_words = [process_word(word) for word in words]
    return ' '.join(processed_words)

def self8_decode(text):
    def process_word(word):
        if len(word) > 1:
            return word[-1] + word[:-1]
        return word
    
    # 通过正则表达式分割单词和标点符号
    result = re.sub(r'\b\w+\b', lambda match: process_word(match.group(0)), text)
    
    return result

def self9_decode(input_str):
    # replacement_table = {
    #     'c': '⊂',
    #     'd': '∂',
    #     'l': '|',
    #     'o': '○',
    #     's': '∫',
    #     't': '⊤',
    #     'v': '∨',
    #     'x': '×'
    # }
    replacement_table = {
        'c': '⊂',
        'd': '∂',
        'l': '|',
        'o': '○',
        's': '∫',
        't': '⊤',
        'v': '∨',
        'x': '×',
        'e': "ϵ",
        'n': "∩",
        "z": "ζ",
        "j": "⅃",
        "y": "Υ",
        # "b": "□"
    }
    decode_table = {v: k for k, v in replacement_table.items()}

    return ''.join(decode_table.get(char, char) for char in input_str)

def self1_decode(s):
    reverse_map = {'e': 'a', 'i': 'e', 'o': 'i', 'u': 'o', 'a': 'u',
                   'E': 'A', 'I': 'E', 'O': 'I', 'U': 'O', 'A': 'U'}
    
    new_string = []
    for char in s:
        if char in reverse_map:
            new_string.append(reverse_map[char])
        else:
            new_string.append(char)
    
    return ''.join(new_string)
# def swap_first_last_letters(word):
#     prefix = ''
#     suffix = ''
    
#     while word and word[0] in string.punctuation:
#         prefix += word[0]
#         word = word[1:]
    
#     while word and word[-1] in string.punctuation:
#         suffix = word[-1] + suffix
#         word = word[:-1]
    
#     if len(word) < 2:
#         return prefix + word + suffix
    
#     swapped_word = word[-1] + word[1:-1] + word[0]
#     return prefix + swapped_word + suffix

# def self10_decode(sentence):
#     words = sentence.split()
#     swapped_words = [swap_first_last_letters(word) for word in words]
#     return ' '.join(swapped_words)

def self0_decode(text):
    return text.replace('-a-', '')


def decode_loeffelsprache(encoded_text):
    vowels = "aeiouAEIOUäöüÄÖÜ"
    decoded_text = ""
    i = 0
    
    while i < len(encoded_text):
        decoded_text += encoded_text[i]
        if encoded_text[i] in vowels:
            # i += 4  # Skip "lew" and the repeated vowel
            if encoded_text[i+1:i+4] == "lew":
                i += 5
            else:
                i += 1
        else:
            i += 1
            
    return decoded_text
def decode_verlan_word(word):
    if len(word) < 2:
        return word
    syllables = []
    temp = ''
    for char in word:
        temp += char
        if char in 'aeiouy' or len(temp) == 2:
            syllables.append(temp)
            temp = ''
    if temp:
        syllables.append(temp)
    
    syllables.reverse()
    
    return ''.join(syllables)

def verlan_decode(sentence):
    words = sentence.split()
    decoded_words = [decode_verlan_word(word) for word in words]
    return ' '.join(decoded_words)

def pig_latin_decode(word):
    if word.endswith("yay"):
        return word[:-3]
    elif word.endswith("ay"):
        word = word[:-2] 
        for i in range(len(word)-1, -1, -1):
            if word[i].lower() in "aeiou":
                return word[i:] + word[:i]
    return word

def pig_latin_decode_sentence(sentence):
    words = sentence.split()
    return ' '.join(pig_latin_decode(word) for word in words)

def backslang_decode(text):
    words = text.split()
    decoded_words = []
    
    for word in words:
        decoded_word = word[::-1]  
        decoded_words.append(decoded_word)
    
    decoded_text = ' '.join(decoded_words)
    return decoded_text

def atbash_cipher_decode(text):
    alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
    reversed_alphabet = alphabet[::-1]
    
    def transform(char):
        if char.isalpha():  
            is_upper = char.isupper()
            char_upper = char.upper()
            index = alphabet.index(char_upper)
            transformed_char = reversed_alphabet[index]
            return transformed_char if is_upper else transformed_char.lower()
        else:
            return char

    transformed_text = ''.join(transform(c) for c in text)
    return transformed_text

def Ubbi_Dubbi_decode(ubbi_dubbi_text):
    import re
    decoded_text = re.sub(r'ub([aeiouAEIOU])', r'\1', ubbi_dubbi_text)
    return decoded_text

def leet_speak_decode(text):
    string = text
    # leet_dict_reverse = {v:k for k,v in leet_dict_decode.items()}
    leet_dict_reverse = leet_dict_decode
    # print(leet_dict_reverse)
    for leet, char in leet_dict_reverse.items():
        string = string.replace(leet, char)
    return string


def aigy_paigy_decode(converted_word):
    syllable_pattern = r'([b-df-hj-np-tv-z]*)aig([aeiou]+(?:[b-df-hj-np-tv-z]*)?)'

    def replace_syllable(match):
        return match.group(1) + match.group(2)

    words = re.split(r'(\W+)', converted_word)  
    original_words = [re.sub(syllable_pattern, replace_syllable, w) if w.isalpha() else w for w in words]

    return ''.join(original_words)

# Alfa Balfa
# "Alfa Balfa"
# f"My question is in {method} format, and you should answer in {method} format. In each syllable of a word, insert 'alf' after the first consonant and//or before the first vowel of the syllable. Thus each syllable becomes two syllables, the first rhyming with 'pal' and the second beginning with the 'f' in 'alf.' E.g. 'hello, how are you?' becomes 'halfellalfo, halfow alfare yalfou?'. Never give any explanations to{method}.\n My question is {encoded_question}.\n {en_step}. step by step. Output detailed explanation."

def alfa_balfa_decode(text):
    def decode_syllable(syllable):
        # Remove "alf" if it appears before a vowel
        return re.sub(r'alf(?=[aeiouAEIOU])', '', syllable)

    # Split the text into words and then syllables
    words = text.split()
    decoded_words = []
    for word in words:
        syllables = re.findall(r'[^aeiouAEIOU]*alf[aeiouAEIOU]+[^aeiouAEIOU]*', word)
        if not syllables:
            # If no "alf" found, take the whole word as a syllable
            syllables = [word]
        decoded_syllables = [decode_syllable(syllable) for syllable in syllables]
        decoded_words.append(''.join(decoded_syllables))
    
    return ' '.join(decoded_words)