import os
import tarfile
import random
import shutil
from pathlib import Path
from PIL import Image
import numpy as np
from tqdm import tqdm

imagenet_root = 'imagenet'  # imagenet folder
train_tar_path = os.path.join(imagenet_root, 'img_train.tar')
train_dir = os.path.join(imagenet_root, 'train')
sampled_train_dir = 'data'
n_sample = 1024
random_seed = 42

random.seed(random_seed)


all_images = []
for class_folder in Path(train_dir).iterdir():
    if class_folder.is_dir():
        for img_file in class_folder.iterdir():
            if img_file.suffix.lower() in ['.jpeg', '.jpg', '.png']:
                all_images.append(img_file)


if len(all_images) < n_sample:
    sampled_images = all_images
else:
    sampled_images = random.sample(all_images, n_sample)

target_dir = os.path.join(sampled_train_dir, "all_classes")
os.makedirs(target_dir, exist_ok=True)

for img_path in tqdm(sampled_images):
    shutil.copy(img_path, os.path.join(target_dir, f"{img_path.parent.name}_{img_path.name}"))



image_arrays = []
image_names = []

for img_path in sampled_images:
    try:
        with Image.open(img_path) as img:
            img = img.convert("RGB")
            img = img.resize((256, 256))
            img_array = np.array(img)
            image_arrays.append(img_array)
            image_names.append(f"{img_path.parent.name}_{img_path.name}")
    except Exception as e:
        print(f"An error occurred while loading the image {img_path.name}: {e}")



