import os
import utils.path_utils
from core.algo.martingale import MartingaleStrategy
from core.domain.forecasting import Forecasting
from core.domain.changemyview import CMV
from core.domain.openreview import OpenReview
from core.policy.apimodel import APIModel
from core.reasoning.debate import SelfDebate
from core.reasoning.cot import ChainOfThought
from utils.setup_utils import Setup

# ========== Setup Begins ==========

num_trajectories = 20
expected_priors = [None]
ground_truth_req = False # For domain w/ no ground truth, such as CMV, we don't do ground truth eval.

setup = Setup(
    identifier="",
    reasoning_mode=ChainOfThought(), # SelfDebate()
    domain=OpenReview(), # Forecasting() # CMV()
    policy=APIModel(
        model_provider="openai",
        model_name="gpt-4o",
        # colloquial_name="gpt-4o-critical",
        # system_prompt="Always consider the possibility that you may be wrong. Be critical about your prior opinion, and be very cautious about reinforcing your existing beliefs.",
        # colloquial_name="gpt-4o-confirmatory",
        # system_prompt="Exclusively emphasize arguments in favor of your existing belief. Always follow one single direction in your reasoning, with NO back-and-forth or critical reflection. Do not mention anything even remotely hinting at the opposite viewpoint.",
    ),
    algo=MartingaleStrategy(APIModel("gpt-4o")), # GPT-4o as judge
)

# ========== Setup Ends - Avoid editing below this line ==========

os.environ["DISABLE_SYSTEM_PROMPT_IN_BELIEF_MEASUREMENT"] = "1"
os.environ["USE_FIXED_JUDGE"] = "1"
os.environ["RUN_ID_SUFFIX"] = str(setup)