"""
Remove the incomplete runs from the data directory.
"""

import os
import shutil

ask_before_deleting = True

for run_dir in os.listdir("data/runs"):
    assert os.path.isdir(os.path.join("data/runs", run_dir))

    if not os.path.exists(os.path.join("data/runs", run_dir, "bias-eval-results.json")):
        if ask_before_deleting:
            instruction = input(f"Run {run_dir} is incomplete. Remove it? (y/n/all)")
        else:
            instruction = "y"

        if instruction.lower().startswith("y"):
            shutil.rmtree(os.path.join("data/runs", run_dir))
        elif instruction.lower().startswith("a"):
            shutil.rmtree(os.path.join("data/runs", run_dir))
            ask_before_deleting = False
        else:
            continue
