import os
import utils.path_utils
import pandas as pd
from matplotlib import pyplot as plt


def plot_score_distribution():
    """
    Plot the score distribution of the runs.
    """
    df = pd.read_csv("data/tmp/causal-attribution-data.csv")
    bias_vals = df["bias"].values
    accuracy_vals = df["accuracy"].values
    
    plt.hist(bias_vals, bins=20, alpha=0.5, label="Bias")
    plt.hist(accuracy_vals, bins=20, alpha=0.5, label="Accuracy")
    plt.legend()
    plt.show()
    
    
if __name__ == "__main__":
    plot_score_distribution()