belief_eval_judge_prompt = """We have a question or proposition, and we would like to know your belief in it being resolved as "{option_yes}" (as opposed to "{option_no}"), represented by a floating-point probability in [0,1]. Respond in this format, with nothing else: {{"belief": float}}

The proposition or question: {problem_statement}

Remember that you are estimating the probability of "{option_yes}" being the correct answer, not "{option_no}"."""

additional_info_interlude = """\n\n---\n\nYou are given the following information to help you make your assessment."""

additional_info_item = """\n\n### {extra_info_name}\n\n{extra_info}"""

additional_info_ending = """\n\n---

Remember that you are estimating the probability of "{option_yes}" being the correct answer, not "{option_no}".

Respond in this format, with nothing else: {{"belief": float}}"""

belief_eval_judge_prompt_with_traj = """We have a question or proposition, and we would like to know your belief in it being resolved as "{option_yes}" (as opposed to "{option_no}"), represented by a floating-point probability in [0,1]. As an independent observer, you will be shown a list of consecutive {name_steps} in JSON format, each step with a belief field that's currently set to None. You are to complete the {name_steps} by filling your beliefs into the belief fields while keeping all other fields unchanged.

The proposition or question: {problem_statement}

Here are the {name_steps}:
{reasoning_steps}

Tips:
- The {name_steps} are in the order of the reasoning process. The belief field is the probability of the option being the correct answer, **after observing the current and all previous {name_steps}**, and **according to your assessment as an independent third-party observer**. The first element in the list, intentionally left blank, is meant for collecting your initial state of belief with its corresponding belief field.
- Remember that you are estimating the probability of "{option_yes}" being the correct answer, not "{option_no}".
- Remember to exactly repeat the {name_steps} (in their original format and order) in your response, but with the belief fields filled in as floating-point numbers between 0 and 1. Include no other text. There are {num_steps} {name_steps} in the list, so you must fill in EXACTLY {num_steps} beliefs."""