# FinFraud-Detection

## Project Structure

The project contains five folders and a main python file:

- **dataset**: store the experiment results(model, log...) and the dataset for experiments(raw data as lob, preprocessed data...)
- **data**: the manipulations to insect frauds and Dataset & DataLoader for different origins and forms of data
- **experiment**: store the configuration file for different experiments and models
- **model**: different representation models
- **scripts** store the shell script to run code
- **utils**: evaluation metrics, configs, different fraud classification methods...
- main.py: the main python file to run the experiment

```
FinFraud Detection
└── dataset
    └── exp_data
    └── raw_data
    └── preprocess_data
└── data
    └── data_preprocess.py
    └── data_manipulated.py
    └── ......
└── experiment
    └── default.json
    └── JFDS.json
    └── ......
└── model
    └── base.py
    └── JFDS.py
    └── ......
└── scripts
    └── run_experiments_in_folder.sh
└── utils
    └── config.py
    └── detection.py
    └── scoring.py
└── main.py
```

## Running the code

### Environment requirements

This project is tested on python 3.12 and based on pytorch, Lightning framework and Comet Logger. To initialize the environment, it is better to create a conda environment and use pip to install necessary packages.

```
conda create -n FraudD python=3.12
pip install -r requirements.txt
```

### Data Preparation

- Step 1: Download raw LOB data of different stocks
- Step 2: Insert market manipulations into raw LOB data
- Step 3: Convert LOB data into different datasets

### Run

**Step 1**: Run the representation part

```
python main.py -c experiment/xxx.json
```

**Step 2**: Copy the model trained in step 1 to corresponding folder

```
python utils/comet_api.py
```

**Step 3**: Run the detection part

```
python main.py -c experiment/xxx.json -e
```

notice: the json file to load is just the same as step 1, since it will automatically find the model path according to the experiment name (so the experiment name should be unique)

### Result

All the results above will be upload to comet, which is configured in default.json.
