from .config import Config
from .comet_api import RecordManager
from .scoring import MSELoss, FreqLoss, WeightedMSELoss, SupervisedContrastiveLoss, MSEContrastiveLoss, performance_matrix, manipulated_level_metrics
from .detection import oc_svm, recon_err_classification, isolation_forest_detection,only_detection
metrics = {
    "mse_loss": MSELoss,
    "freq_loss": FreqLoss,
    "wmse_loss": WeightedMSELoss,
    "contrastive_loss": SupervisedContrastiveLoss,
    "combined_loss": MSEContrastiveLoss
}