import open3d as o3d
import numpy as np
import matplotlib.pyplot as plt
import torch

# 加载 .npz 文件
file_path = '/home/cv/gjl/Pointcept/exp/scannet/default/visualization/scene0081_02_vis_grad_map.npz'
data = np.load(file_path, allow_pickle=True)

coords = data['coord']
attributes = data['attr'].flatten()
attributes = np.log10(attributes + 1e-6)

# coord = pc_data['coord'][:163792]
# color = pc_data['color'][:163792]

# color = (color - color.min()) / (color.max() - color.min())
attributes = (attributes - attributes.min()) / (attributes.max() - attributes.min())

# 平移 pcd2 的坐标，使其与 pcd1 分开显示
translation_vector = np.array([2.0, 0.0, 0.0])  # 可以调整此向量以实现所需的分离
# coord_translated = coord + translation_vector

# 创建 Open3D 点云对象
pcd1 = o3d.geometry.PointCloud()
pcd1.points = o3d.utility.Vector3dVector(coords)

pcd2 = o3d.geometry.PointCloud()
# pcd2.points = o3d.utility.Vector3dVector(coord_translated)

# 使用 viridis 色图将归一化的属性值映射到 RGB 颜色
cmap = plt.cm.get_cmap("turbo")
colors = cmap(attributes)[:, :3]

# 将颜色分配给点云对象
pcd1.colors = o3d.utility.Vector3dVector(colors)
# pcd2.colors = o3d.utility.Vector3dVector(color)




# 创建可视化窗口
vis = o3d.visualization.Visualizer()
vis.create_window(window_name="Combined Point Clouds")

# 添加点云到窗口
vis.add_geometry(pcd1)
vis.add_geometry(pcd2)

# 获取渲染选项
render_option = vis.get_render_option()
render_option.point_size = 8  # 调整点的大小，默认是1.0

# 运行可视化
vis.run()
vis.destroy_window()
