from .gym_parser import parse_gym_environment


def parse_unity_environment(env_name):
    '''
    Generates a regym.environments.Task generated by creating a Unity Environment
    (mlagents-envs) and extracting data from the environment.

    :param env_name: Path to Unity Executable
    :returns: Task created from :param: env_name
    '''
    if 'obstacletower' not in env_name: raise ValueError('Only obstacletower environment currently supported')
    from obstacle_tower_env import ObstacleTowerEnv
    env = ObstacleTowerEnv(env_name, retro=True, realtime_mode=False, worker_id=0) # retro=True mode creates an observation space of a 64x64 (Box) image
    return parse_gym_environment(env, name=env_name)
