import pandas as pd

# Load CSVs
df_train = pd.read_csv('/datasets/fairface_label_train.csv')
df_val = pd.read_csv('/datasets/fairface_label_val.csv')

# Update file names for train (strip 'train/')
df_train['file'] = df_train['file'].apply(lambda x: x.replace('train/', ''))

# Update file names for val (replace 'val/' with 'val_')
df_val['file'] = df_val['file'].apply(lambda x: x.replace('val/', 'val_'))

# Combine dataframes
df_combined = pd.concat([df_train, df_val], ignore_index=True)

# Save to new CSV
df_combined.to_csv('all_data.csv', index=False)
print("Combined CSV saved as all_data.csv")
