# On the detection of synthetic images generated by diffusion models

[![Github](https://img.shields.io/badge/Github%20webpage-222222.svg?style=for-the-badge&logo=github)](https://grip-unina.github.io/DMimageDetection/)
[![arXiv](https://img.shields.io/badge/-arXiv-B31B1B.svg?style=for-the-badge)](https://arxiv.org/abs/2211.00680)
[![IEEE](https://img.shields.io/badge/-IEEE-6093BF.svg?style=for-the-badge)](https://doi.org/10.1109/ICASSP49357.2023.10095167)
[![GRIP](https://img.shields.io/badge/-GRIP-0888ef.svg?style=for-the-badge)](https://www.grip.unina.it)


This is the official training code of the paper:
[On the detection of synthetic images generated by diffusion models](https://arxiv.org/abs/2211.00680).
Riccardo Corvi, Davide Cozzolino, Giada Zingarini, Giovanni Poggi, Koki Nagano, Luisa Verdoliva

## Traning-set

#### 1) ProGAN Traning-set
For training using ProGAN images, we used the traning-set provided by ["CNN-generated images are surprisingly easy to spot...for now"](https://github.com/PeterWang512/CNNDetection)
 
#### 2) Latent Diffusion Traning-set
For training using Latent Diffusion images, we generated 200K fake images, while the 200K real images come from two public datasets, [COCO - Common Objects in Context](https://cocodataset.org/#home) and  [LSUN - Large-scale Scene Understanding](https://www.yf.io/p/lsun).
The fake images and the lists of used real images can be downloaded [here](https://www.grip.unina.it/download/prog/DMimageDetection/latent_diffusion_trainingset.zip).
If you plan to use the dataset, please cite our paper ["On the detection of synthetic images generated by diffusion models"](https://doi.org/10.1109/ICASSP49357.2023.10095167).

```
Dataset directory
|--train
|   |--latent_diffusion_class2image
|   |   |--0_real
|   |   |--1_fake
|   |--latent_diffusion_noise2image_FFHQ
|   |   |--0_real
|   |   |--1_fake
|   .
|   .
|   .
|   |--latent_diffusion_text2img_train2
|       |--0_real
|       |--1_fake
|--val
    |--latent_diffusion_class2image
    |   |--0_real
    |   |--1_fake
    |--latent_diffusion_noise2image_FFHQ
    |   |--0_real
    |   |--1_fake
    .
    .
    .
    |--latent_diffusion_text2img_train2
        |--0_real
        |--1_fake
```
There should be two folders, one for training and one for validation. These folders should contain the subfolders present in the zip file. Each subfolders should have two subfolders each one with fake images (1_fake) and one with real images (0_real).
If the pytorch version used is >1.12.0 no folder should be left empty, otherwise the code would not run.

## Code

To launch the training with the augmentation provided in the paper, please use the following command:

```
python train.py --name name_of_the_checkpoints_folder --arch res50nodown --cropSize 96  --norm_type resnet --resize_size 256 --resize_ratio 0.75 --blur_sig 0.0,3.0 --cmp_method cv2,pil --cmp_qual 30,100 --resize_prob 0.2 --jitter_prob  0.8 --colordist_prob 0.2 --cutout_prob 0.2 --noise_prob 0.2 --blur_prob 0.5 --cmp_prob 0.5 --rot90_prob 1.0 --dataroot /path/to/the/parent/directory/
```

It is possible to use also the bash script provided.

```
./script_train_test.sh

```

By default the code creates a folder called checkpoints in the current directory. If you want to change where the checkpoints folder is saved please add the following argument:
```
--checkpoints_dir /path/to/weights/folder
```

## License

Copyright 2024 Image Processing Research Group of University Federico
II of Naples ('GRIP-UNINA'). All rights reserved.
                        
Licensed under the Apache License, Version 2.0 (the "License");       
you may not use this file except in compliance with the License. 
You may obtain a copy of the License at                    
                                           
    http://www.apache.org/licenses/LICENSE-2.0
                                                      
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,    
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.                         
See the License for the specific language governing permissions and
limitations under the License.

## Bibtex 

```
@InProceedings{Corvi_2023_ICASSP,
  author={Corvi, Riccardo and Cozzolino, Davide and Zingarini, Giada and Poggi, Giovanni and Nagano, Koki and Verdoliva, Luisa},
  title={On The Detection of Synthetic Images Generated by Diffusion Models},
  booktitle={IEEE International Conference on Acoustics, Speech and Signal Processing (ICASSP)}, 
  year={2023},
  pages={1-5},
  doi={10.1109/ICASSP49357.2023.10095167}
}
```
