# Evaluate detectors on the adversarial ELSA test set generated by the ensemble model

# Available Models
# ojha2023, corvi2023, cavia2024, chen2024_convnext, chen2024_clip, koutlis2024, wang2020

# for model in cavia2024 chen2024_convnext chen2024_clip corvi2023 koutlis2024 ojha2023 wang2020; do
#   python src/raid/evaluate_detector.py \
#   --model $model \
#   --path_to_dataset data/RAID/<select_subfolder> \
#   --dataset_type subfolders \
#   --output_dir output/evaluate_detector \
#   --batch_size 50 \
#   --num_workers 1 \
#   --subset -1
# done


# Adversarial dataset evaluation

#  --path_to_dataset "data/ADV/ELSA_TEST_1/adv_avg_['ojha2023', 'corvi2023', 'cavia2024', 'chen2024_convnext', 'chen2024_clip', 'koutlis2024', 'wang2020']_16_255_10_0.005/adv_dataset.pkl" \

for model in ojha2023 corvi2023 cavia2024 chen2024_convnext chen2024_clip koutlis2024 wang2020; do
  python src/raid/evaluate_detector.py \
  --model $model \
  --path_to_dataset "data/ADV/val/adv_raw_['cavia2024']_32_255_10_0.05/adv_dataset.pkl" \
  --dataset_type dataset \
  --output_dir output/evaluate_detector \
  --batch_size 1 \
  --num_workers 1 \
  --subset -1
done


# to evaluate detectors on ForenSynths use:
#   --path-to-dataset data/CNN_synth_testset
#   --dataset-type wang2020