# mmr_gym/complexity/base.py
from typing import Dict, Any
from ..schema import ComplexityReport

def assign_level(score: float) -> int:
    # simple global mapping; adjust later or quantile-fit
    if score < 25: return 1
    if score < 45: return 2
    if score < 65: return 3
    if score < 85: return 4
    return 5

class Scorer:
    version = "0.1"
    def score_from_features(self, feats: Dict[str, Any]) -> ComplexityReport:
        raise NotImplementedError
