# mmr_gym/complexity/registry.py
from .scorers import SymmetryScorer, SequenceScorer, MissingPatchScorer

_SCORERS = {
    "symmetry": SymmetryScorer(),
    "sequence": SequenceScorer(),
    "missing_patch": MissingPatchScorer(),
}

def get_scorer(task_name: str):
    return _SCORERS.get(task_name, SymmetryScorer())
