# mmr_gym/complexity/scorers.py
from typing import Dict, Any
from .base import Scorer, assign_level
from ..schema import ComplexityReport

class SymmetryScorer(Scorer):
    version = "symmetry@0.1"
    def score_from_features(self, feats: Dict[str, Any]) -> ComplexityReport:
        visual = feats.get("visual_complexity", 12.0)
        rule = feats.get("rule_weight", 15.0)
        conf = feats.get("min_option_distance", 10.0)
        score = min(100.0, visual + rule + conf)
        return ComplexityReport(score, assign_level(score), self.version,
                                {"visual":visual,"rule":rule,"conf":conf}, notes=feats)

class SequenceScorer(Scorer):
    version = "sequence@0.1"
    def score_from_features(self, feats: Dict[str, Any]) -> ComplexityReport:
        arity = feats.get("rule_arity", 1)
        step = feats.get("mean_step_norm", 0.3) * 40
        conf = feats.get("min_option_distance", 12.0)
        score = min(100.0, 10*arity + step + conf)
        return ComplexityReport(score, assign_level(score), self.version,
                                {"arity":10*arity,"step":step,"conf":conf}, notes=feats)

class MissingPatchScorer(Scorer):
    version = "missing_patch@0.1"
    def score_from_features(self, feats: Dict[str, Any]) -> ComplexityReport:
        grid = feats.get("grid_area", 16)
        structure = feats.get("pattern_redundancy", 8.0)
        conf = feats.get("min_option_distance", 8.0)
        score = min(100.0, 0.8*grid + structure + conf)
        return ComplexityReport(score, assign_level(score), self.version,
                                {"grid":0.8*grid,"structure":structure,"conf":conf}, notes=feats)
