# mmr_gym/tasks/__init__.py
from .symmetry import (
    SymmetryGridMirrorFillTask,
    SymmetrySceneMirrorIdentifyTask,
    SymmetryFriezeGroupsTask,
    SymmetryWallpaperGroupsTask,
)
from .sequence import SequenceArithmeticTask, SequenceRotationTask, SequenceMultiColumnArithmeticTask
from .transform import TransformResultIdentifyTask, TransformPairInferTask
from .tiles import (
    TilesConnectedComponentTask,
    TilesShortestPathTask,
    TilesMissingTilesTask,
    TilesDecomposeComposeTask,
    TilesGeometryTask,
    TilesRecoloringTask,
    TilesLineLengthTask,
    TilesLineIntersectionsTask
)

from .counting import ShapeCountTask

from .charts import ChartsPieTask, ChartsMatchProportionsTask

from .geometric import GeometricSortTask, GeometricPositionTask, GeometricStackCountTask


from .rect_venn import RectVennTask

__all__ = [
    "SymmetryGridMirrorFillTask",
    "SymmetrySceneMirrorIdentifyTask",
    "SymmetryFriezeGroupsTask",
    "SymmetryWallpaperGroupsTask",
    "SequenceArithmeticTask",
    "SequenceRotationTask",
    "TransformResultIdentifyTask",
    "TransformPairInferTask",
    "TilesConnectedComponentTask",
    "TilesShortestPathTask",
    "TilesMissingTilesTask",
    "TilesDecomposeComposeTask",
    "SequenceMultiColumnArithmeticTask",
    "TilesGeometryTask",
    "ShapeCountTask",
    "ChartsPieTask",
    "GeometricSortTask",
    "RectVennTask",
    "TilesRecoloringTask",
    "GeometricPositionTask",
    "GeometricStackCountTask",
    "ChartsMatchProportionsTask",
    "TilesLineLengthTask",
    "TilesLineIntersectionsTask",
]
