import run_SA_wishart
import numpy as np

from tqdm import tqdm
import time

import itertools
import lib

import os


biasl = [0.0,6.0,8.0,10.0,12.0]

Nl = [60,100,120,140,160]
T = [50,100,300,500,1000,2000,3000,4000]

#Nl = [60,100,120]
#T = [50,100,300]


pt_device = 'cuda'
#pt_device = 'cpu'

alphatxt = '0.80'


####################################################
#SOLVER

solvertypel = ['SA']

debug = 0

for bias in biasl:


    data = {}
    if bias==0:
        data['datatype'] = 'unbias'
    else:
        data['datatype'] = 'bias'

    if data['datatype'] == 'unbias':
        data['D_WPE'] = 1 # 3
        data['R_WPE'] = -1 # 6
        
        data['bias'] = 0.0
        
    elif data['datatype'] == 'bias':
        #first GS is close to ferromagnetic
        data['D1_WPE'] = 1
        data['R1_WPE'] = 3
        
        #second GS is random
        data['D2_WPE'] = 1
        data['R2_WPE'] = -1
        
        data['bias'] = bias


        data['D_WPE'] = data['D1_WPE'] + data['D2_WPE']

        bias = data['bias']

    ####################################################

    total = len(Nl) * len(T)

    afolder_name = []

    for solvertype in solvertypel:

        fMH = 0.0

        #folder_name = lib.create_timestamped_folder(solvertype)
        folder_name = f"{solvertype}_{bias}_{fMH}"
        
        # Check if the folder already exists
        if not os.path.exists(folder_name):
            # Create the folder if it doesn't exist
            os.makedirs(folder_name)
            print(f"Folder created: {folder_name}")
        else:
            print(f"Folder already exists: {folder_name}")
            
        
        # Use tqdm with itertools.product to iterate over all combinations
        for combination in tqdm(itertools.product(Nl, np.flip(T)), desc="Iterating combinations"):
    
            if solvertype=='SA':
                PARAM_NAMES = ["beta_start","beta_end"]
                x = np.log([0.1,0.1])
                hyperparams = {'T': combination[1], 'K': 400, 'use_default_beta': True}
                    
            #generate problem instance
            instance = {'alphatxt':alphatxt, 'N': combination[0]}
            flags = {'savetraj':1, 'pt_device': pt_device,'solvertype':solvertype}
            #tunerparams = {'nsamp_max': 5000, 'R': 200}
            tunerparams = {'nsamp_max': 100000, 'R': 200}
            #x = [0.1,1.0,0.1,1.0]
            
            run_SA_wishart.run_wishart(folder_name,instance,hyperparams,PARAM_NAMES,x,flags,tunerparams,data)
            
            if 0:
                if combination[1]==np.min(hyperparams['T']):
                    file_name = f"wishart_{combination[0]}_{alphatxt}_{np.max(hyperparams['T'])}.txt"
                else:
                    file_name = f"wishart_{combination[0]}_{alphatxt}_{combination[1]}.txt"
                    
                p0, opt_params, pvec = lib.read_file(folder_name, file_name)
                x = np.log(opt_params)
                
        afolder_name.append(folder_name)


    ####################################################
