import tune_gset_wrap
import numpy as np

from tqdm import tqdm
import time

import itertools
import lib

import os

####################################################
#DATA

Nl = [800]
T = [3000,6000] 
T = [3000]              #around 10^4
i0l = [0,1,2,3, 4,5,6,7] #instance id

pt_device = 'cuda'
#pt_device = 'cpu'

#nsamp_max = 10000 # max iter for tune
nsamp_max = 200000

fMH = 0.1

####################################################
#SOLVER

solvertypel = ['MHCACm']

debug = 0


fMHv = {}
fMHv['CACm'] = 0.0
fMHv['AIM'] = 0.0
fMHv['CAC'] = 0.0
fMHv['MHCACm'] = 0.1
fMHv['MHCAC'] = 0.1

####################################################

total = len(Nl) * len(T)

for i0 in i0l:


    afolder_name = []

    for solvertype in solvertypel:

        #folder_name = lib.create_timestamped_folder(solvertype)
        folder_name = f"GSET_{solvertype}_{fMH}"
        
        # Check if the folder already exists
        if not os.path.exists(folder_name):
            # Create the folder if it doesn't exist
            os.makedirs(folder_name)
            print(f"Folder created: {folder_name}")
        else:
            print(f"Folder already exists: {folder_name}")
            
        
        # Use tqdm with itertools.product to iterate over all combinations
        for combination in tqdm(itertools.product(Nl, np.flip(T)), desc="Iterating combinations"):
        
            fMH = fMHv[solvertype]
            if solvertype=='MHCACm':
                PARAM_NAMES = ["beta","kappa","lamb","xi","gamma","a"]
                x = np.log([0.1,0.1,1.0,0.1,1.0,1.0]) #lamb=1 important
                hyperparams = {'T': combination[1],'doa':1,'dosampling':0,'fMH':fMH}
           
            if solvertype=='MHCAC':
                PARAM_NAMES = ["beta","kappa","lamb","xi","a"]
                x = np.log([0.1,0.1,0.1,0.1,1.0])
                hyperparams = {'T': combination[1],'doa':0,'dosampling':0,'fMH':1.0}
            
            if solvertype=='CACm':
                PARAM_NAMES = ["beta","lamb","xi","gamma","a"]
                x = np.log([0.1,1.0,0.1,1.0,1.0])
                hyperparams = {'T': combination[1],'fMH':fMH}
            
            if solvertype=='CAC':
                PARAM_NAMES = ["beta","lamb","xi","a"]
                x = np.log([0.1,1.0,0.1,1.0])
                hyperparams = {'T': combination[1],'fMH':fMH}
            
            if solvertype=='AIM':
                PARAM_NAMES = ["beta","lamb","gamma"]
                x = np.log([0.1,1.0,1.0])
                hyperparams = {'T': combination[1],'fMH':fMH}
                
            #generate problem instance
            instance = {'N': combination[0], 'id': i0}
            flags = {'savetraj':1, 'pt_device': pt_device,'solvertype':solvertype}
            tunerparams = {'nsamp_max': nsamp_max, 'R': 50}
            
            tune_gset_wrap.tune_gset(folder_name,instance,hyperparams,PARAM_NAMES,x,flags,tunerparams)
            
        afolder_name.append(folder_name)


    ####################################################
