import numpy as np
import qubovert as qv
import qubovert.utils
import generate_dWPE
import time
import os

N = 60
alpha = 0.8

#first GS is close to ferromagnetic
D1_WPE = 1
R1_WPE = 3

#second GS is random
D2_WPE = 1
R2_WPE = -1

#bias away from ferromagnetic
bias = 6.0

D_WPE = D1_WPE + D2_WPE

T = 5000
R = 3000

start_flip_prob = 0.5
end_flip_prob = 0.001

Ps_any_list = []

T_list = [100, 250,500,1000,2000,5000,10000]
Ps_all_list = []
inst_i = 1


for T in T_list:
	tme = time.time()
	
	M = int(N*alpha)
	
	J, E0, gs = generate_dWPE.gen_dWPE_cluster(inst_i, N, M, D1_WPE, R1_WPE, D2_WPE, R2_WPE, bias =  bias)
	eps0 = 10**(-6)
	
	J_bias = np.ones((N,N))
	J_bias = J_bias - np.diag(np.diag(J_bias))
	J = J + (0)*J_bias*10**(-4)

	H = qubovert.utils.matrix_to_qubo(-J)
	
	#Q = H.to_quso()
	time1 = time.time() - tme
	tme = time.time()
	
	
	temperature_range = qv.sim.anneal_temperature_range(H, start_flip_prob = start_flip_prob, end_flip_prob = end_flip_prob)
	print(temperature_range)
	temperature_range = (200.0, 20.0)
	print(temperature_range)
	anneal_res = qv.sim.anneal_quso(H, num_anneals=R, anneal_duration = T, temperature_range = temperature_range)
	
	time2 = time.time()  -tme
	#print(anneal_res.best.value)
	
	n_found = [0]*D_WPE
	
	for res in anneal_res:
		s = [res.state[i] for i in range(N)]
		
		E = res.value
		
		#print(E, E0*2)
		s = np.array(s, dtype = float)
		#print(E, E0*2)
		#print(E,s)
		if(E <= E0*2 + eps0):
			
			found = False
			for i in range(D_WPE):
				s = s/s[0]
				#print(s - (gs[:,i]/gs[0,i]))
				if( (s == (gs[:,i]/gs[0,i])).all() ):
					n_found[i] += 1
					found = True
			
			if(not found):
				print("found spurious GS ", s)
	Ps_any = np.sum(n_found)/R	
	Ps_any_list.append(Ps_any)
		
	print(inst_i, "Ps", np.array(n_found)/R, time2)
	
	
	Ps_all_list.append(np.array(n_found)/R)

print(np.average(Ps_any_list), np.median(Ps_any_list))


outdir = "sampling_out/"

out = np.zeros((len(T_list),3))
out[:,0] = T_list
out[:,1] = [Ps[0] for Ps in Ps_all_list]
out[:,2] = [Ps[1] for Ps in Ps_all_list]

if(not os.path.exists(outdir)):
	os.makedirs(outdir)
	

np.savetxt(outdir + "SA_N_%i_alpha_%i.txt" % (N, alpha), out)




