import CAC_Ising

import DASTuneADAM as DASTuner

import lib

import numpy as np
import time

from tqdm import tqdm

#generate problem instance
alphatxt = '0.80'
R = 5000
i = 0

# Solver parameters
N = 100
T=100
x = [0.167*0.5,1.74*0.5,0.07,1.29*0.5] #N=60

# flags

#CACm alpha, beta, xi, a, gamma
PARAM_NAMES = ["beta","lamb","xi","gamma"]

x_init = np.array(x)
L_init = np.diag(np.ones(len(x))*0.5)
x = np.expand_dims(x,1)
x = np.tile(x,[1,R])

savetraj = 1

#pt_device = "cpu"
pt_device = "cuda"

J, eps0, H0 = lib.load_wishart(N,alphatxt,i)


solver = CAC_Ising.CAC(pt_device, N, J=J, H0=H0)
solver.eps = eps0
solver.T = T

for idx, param_name in enumerate(PARAM_NAMES):
    setattr(solver, param_name, x[idx, :])
    
solver.init(R)

    
# 
# #solve
print("solving")

tstart = time.time()
Ps, E_opt = solver.traj(H0)
p0 = np.mean(E_opt==H0)
TTS = np.log(1-0.99)/np.log(1-p0)*T
print(p0,TTS,np.min(E_opt),H0)


