import CAC_Ising

import lib

import numpy as np
import time

from tqdm import tqdm

import generate_dWPE

#parameters
N = 60
T = 100

solvertype = 'MHCACm'
PARAM_NAMES = ["beta","kappa","lamb","xi","gamma","a"]
hyperparams = {'T': T,'doa':1,'dosampling':0,'fMH':0.3}

#generate problem instance
alphatxt = '0.80'
R = 5000

i = 0
if 0:

    J, eps0, H0 = lib.load_wishart(N,alphatxt,i)
    prec = 1
    
else:
    alpha = 0.8
    D_WPE = 10
    R_WPE = -1
    M = int(N*alpha)
    J, H0, gs = generate_dWPE.gen_dWPE(i, N, M, D_WPE, R_WPE)
    eps0 = np.mean(np.abs(J))
    
    prec = 10**(-6) #precision for GS energy
    H0 = np.floor(H0/prec)
    
    gs = (np.array(gs).T).tolist()
    gs.extend((-np.array(gs)).tolist())
    
    #for x in gs.T:
    #    E = -0.5*np.sum(x * (J @ x))
    #    E = np.floor(E/prec)
    #    print(E,H0)
        
#load optimal parameters
folder_name = '2024-05-19_11-50-45_MHCACm'
file_name = f"wishart_{N}_{alphatxt}_{T}.txt"
p0, opt_params, pvec = lib.read_file(folder_name, file_name) 
#opt_params = [0.15682347, 0.10007394, 0.5218006 , 0.08530486, 0.55129337, 0.78861591]
x = np.log(opt_params)
x = np.expand_dims(x,1)
x = np.tile(x,[1,R])

#pt_device = "cpu"
pt_device = "cuda"

#run
solver = CAC_Ising.CAC(pt_device, N, J=J, H0=H0, solvertype = solvertype, precGS = prec)
solver.eps = eps0

for idx, param_name in enumerate(PARAM_NAMES):
    setattr(solver, param_name, np.exp(x[idx, :]))
    
solver.init(R,PARAM_NAMES,hyperparams)

# #solve
print("solving")

tstart = time.time()
Ps, E_opt = solver.traj(H0)
p0 = np.mean(E_opt==H0)
TTS = np.log(1-0.99)/np.log(1-p0)*T
print(p0,TTS,np.min(E_opt),H0)

# count recurrence of GS
count_rec = lib.count_vector_occurrences(solver.allGS,gs)

p0min = np.min(count_rec)/R #probability of finding all GS
TTSmin = T*np.log(1-0.99)/np.log(1-p0min)