import SA_Ising
import lib
import numpy as np
import time
    
import os

import generate_dWPE

def run_wishart(folder_name,instance,hyperparams,PARAM_NAMES,x,flags,tunerparams,data):

    N = instance['N']
    alphatxt = instance['alphatxt']
    solvertype = flags['solvertype']
    T = hyperparams['T']
    K = hyperparams['K']
    
    N_inst = 15
    
    evalist = [] # vector of success probability
    for r in range(N_inst):
        
            
        if data['datatype'] == 'load':
            #load instance
            i = int(10* np.random.rand())
            J, eps0, H0 = lib.load_wishart(N,alphatxt,i)
            prec = 1
            
        else:
            
            i = int(100000* np.random.rand())
            alpha = float(alphatxt)
            M = int(N*alpha)
            
            if data['datatype']=='unbias':
                J, H0, gs = generate_dWPE.gen_dWPE(i, N, M, data['D_WPE'], data['R_WPE'])
            elif data['datatype']=='bias':
                J, H0, gs = generate_dWPE.gen_dWPE_cluster(i, N, M, data['D1_WPE'], data['R1_WPE'], data['D2_WPE'], data['R2_WPE'], bias =  data['bias'])
                J_bias = np.ones((N,N))
                J_bias = J_bias - np.diag(np.diag(J_bias))
                J = J + (0)*J_bias*10**(-4)
    
                
            prec = 10**(-6) #precision for GS energy
            H0 = np.floor(H0/prec)
                
    
    
        #setup solver
        solver = SA_Ising.SA(N, J, H0, prec)
    
        #get default beta
        beta_start,beta_end = solver. get_default_beta()
        beta_start = beta_start
        beta_end = beta_end
     
        #run
        energies, solutions = solver.run_SA_neal(beta_start,beta_end,K,T)
    
        #evaluate
        p0 = np.mean(energies==H0)
        evalist.append(p0)
        
    f_eval = np.mean(evalist)
        
    param_out = [beta_start,beta_end] # save only for the last instance the best interval of beta
   
    #save results
    bias = data['bias']
    fMH = 0.0
    file_name = f"wishart_{N}_{alphatxt}_{bias}_{T}_{fMH}.txt"
    lib.save_to_file(folder_name, file_name, f_eval, evalist, param_out)
    