import subprocess

# List of python files to run
python_files = ["fig2_BoltzmannDistribution.py", "fig2_effectiveTemperature.py", "fig3_tune_wishart.py", "fig3_SA_tune_wishart.py", , "fig3_PT_tune_wishart.py", "fig3_plotoptimization.py", "fig3_run_allGS.py","fig3_SA_allGS.py","fig3_PT_allGS.py","fig3_plot_all_GS.py","table2_tune_gset.py"]

for file in python_files:
    try:
        print(f"Running {file}...")
        result = subprocess.run(["python", file], check=True, capture_output=False, text=True)
        print(f"Successfully ran {file}")
        print("Output:\n", result.stdout)
    except subprocess.CalledProcessError as e:
        print(f"Error occurred while running {file}")
        print("Error message:\n", e.stderr)
        break  # Stop executing further files if there is an error