## game.py
from dice import Dice
from ui import UI

class Game:
    def __init__(self, number_of_dice: int = 1):
        """
        Initialize the game with a given number of dice.

        Args:
            number_of_dice (int): The number of dice in the game, default is 1.
        """
        self._number_of_dice = number_of_dice
        self._dice = [Dice() for _ in range(number_of_dice)]  # Create a list of Dice instances
        self._ui = UI(self)

    def start_game(self):
        """
        Start the game by displaying the UI and allowing the user to roll dice.
        """
        self._ui.start()

    def roll_dice(self) -> int:
        """
        Roll the dice and return the result.

        Returns:
            int: The sum of the results from rolling the specified number of dice.
        """
        return sum(dice.roll() for dice in self._dice)

    def set_number_of_dice(self, number: int):
        """
        Set the number of dice to be used in the game.

        Args:
            number (int): The number of dice to set.
        """
        self._number_of_dice = number
        self._dice = [Dice() for _ in range(number)]  # Update the list of Dice instances


