## word_cloud_generator.py
from wordcloud import WordCloud
from typing import Dict, Any
import matplotlib.pyplot as plt
from PIL import Image
import io

class WordCloudGenerator:
    def __init__(self):
        # Constructor for WordCloudGenerator, no initialization required for this example
        pass

    def generate_word_cloud(self, frequencies: Dict[str, int], settings: Dict[str, Any]) -> Image:
        """
        Generates a word cloud image from the given frequencies and settings.

        :param frequencies: A dictionary with words as keys and their frequencies as values.
        :param settings: A dictionary containing settings for the word cloud generation.
        :return: A PIL Image object of the generated word cloud.
        """
        # Set default values for settings
        width = settings.get('width', 800)
        height = settings.get('height', 600)
        max_words = settings.get('max_words', 200)
        background_color = settings.get('background_color', 'white')
        
        # Generate the word cloud
        word_cloud = WordCloud(width=width, height=height, max_words=max_words, background_color=background_color)
        word_cloud.generate_from_frequencies(frequencies)

        # Convert to image
        image = word_cloud.to_image()

        # If specified, save the image
        if 'output_path' in settings:
            image.save(settings['output_path'])

        return image
