import os
import argparse
from src.utils import change_dir
from src.utils import load_yaml, list_to_dict_by_task
from utils.test_code import *
from utils.json_operator import *
from utils.used_libs import *
from utils.cr_for_bcb import *
import shutil


def parse_arguments():
    parser = argparse.ArgumentParser(description="For Generation Progress Check")
    parser.add_argument("--model_id", type=str, default="gpt-4-turbo-ca", 
                        choices=['o1-mini', "gpt-4o-2024-05-13", 'gpt-4-turbo', 'gpt-4o-mini','claude-3-5-sonnet-20240620', 
                                #  "claude-3-opus-20240229", 
                                 "glm-4-flash", 
                                 "deepseek-coder-1.3b-instruct", "deepseek-coder-6.7b-instruct", "deepseek-coder-33b-instruct", "CodeLlama-7b-Instruct-hf", "CodeLlama-13b-Instruct-hf", "CodeLlama-34b-Instruct-hf" 
                                 "Qwen2.5-Coder-1.5B-Instruct", "starcoder2-3b", "starcoder2-7b", "starcoder2-15b", 
                                 "Meta-Llama-3.1-70B-Instruct"], help="Specify the model id")

    args = parser.parse_args()
    return args


def main(all_args):
    output_dir = 'data'
    model_id = all_args.model_id
    all_models = ['o1-mini', "gpt-4o-2024-05-13", 'gpt-4-turbo', 'gpt-4o-mini','claude-3-5-sonnet-20240620', "glm-4-flash", #"claude-3-opus-20240229", 
                "deepseek-coder-1.3b-instruct", "deepseek-coder-6.7b-instruct", "deepseek-coder-33b-instruct", "CodeLlama-7b-Instruct-hf", "CodeLlama-13b-Instruct-hf", "CodeLlama-34b-Instruct-hf", 
                "Qwen2.5-Coder-1.5B-Instruct", "starcoder2-3b", "starcoder2-7b", "starcoder2-15b", 
                "Meta-Llama-3.1-70B-Instruct", 
                "Qwen/Qwen2.5-Coder-7B-Instruct", "01-ai/Yi-1.5-9B-Chat-16K", "google/gemma-2-9b-it", "meta-llama/Meta-Llama-3-8B-Instruct", "meta-llama/Meta-Llama-3.1-8B-Instruct", "Qwen/Qwen2-1.5B-Instruct", "Qwen/Qwen2-7B-Instruct", "Qwen/Qwen2.5-7B-Instruct", "THUDM/glm-4-9b-chat"
                ]
    for model_id in all_models:
        should_complete = 0
        actual_complete = 0
        uncompleted_tasks = []

        # check progress on all tasks
        for dir_ in os.listdir(output_dir):
            if os.path.isdir(os.path.join(output_dir, dir_)):
                # print(f"Evaluating Prompt ID: --{dir_}--\n")
                output_file_path = os.path.join(output_dir, dir_, f"{model_id}_outputs.jsonl")
                output_datas = read_json(output_file_path)
                should_complete += 10
                actual_complete += min(10, len(output_datas))
                if len(output_datas) < 10:
                    uncompleted_tasks.append(dir_)

        # show results
        print(f"{model_id} current progress: [{actual_complete}/{should_complete}]")
        # if len(uncompleted_tasks) > 0:
        #     print(f"Uncompleted Tasks: {uncompleted_tasks}\n")
        # else:
        #     print("All tasks completed!\n")


if __name__ == '__main__':
    args = parse_arguments()
    main(args)
