# config list
configs=("glm-4-flash_config.yaml")

# data type list
# data_types=("human" "bcb" "csv_excel" "dl")
data_types=("human")

dl_ids=("human_18" "human_132")

# iterate through model list
for config in "${configs[@]}"; do
    echo "Running tests for config: $config"
    
    # iterate through data type list
    for data_type in "${data_types[@]}"; do
        echo "  Running data type: $data_type"
        for dl_id in "${dl_ids[@]}"; do
            echo "  Running dl_id: $dl_id"
            python -m experiments.run_examples --data_type $data_type --task_id $dl_id --max_run 10 --config $config
        done
    done
    
    echo "Completed tests for config: $config"
    echo
done

echo "All tests completed."
