vidvrd_categories = ['__background__',  # always index 0
            'airplane', 'antelope', 'bear', 'bicycle',
            'bird', 'bus', 'car', 'cattle',
            'dog', 'domestic_cat', 'elephant', 'fox',
            'giant_panda', 'hamster', 'horse', 'lion',
            'lizard', 'monkey', 'motorcycle', 'rabbit',
            'red_panda', 'sheep', 'snake', 'squirrel',
            'tiger', 'train', 'turtle', 'watercraft',
            'whale', 'zebra',                               # 前面几行的顺序和imagenet-DET中的顺序相同
            'ball','frisbee','sofa','skateboard','person']  # 最后一行是不在 imageNet-DET中的类
vidvrd_CatId2name = {idx:cat for idx,cat in enumerate(vidvrd_categories)}
vidvrd_CatName2Id = {cat:idx for idx,cat in enumerate(vidvrd_categories)}


PKU_vidvrd_categories = ['__background__','lion','bear','domestic_cat','elephant',
'motorcycle','giant_panda','frisbee',
'watercraft','bicycle','train','zebra',
'antelope','turtle','bus','sofa','airplane',
'bird','monkey','cattle','tiger','dog','squirrel',
'rabbit','car','snake','hamster','lizard','whale',
'red_panda','fox','person','ball','sheep','skateboard','horse'
]
PKU_vidvrd_CatId2name = {idx:cat for idx,cat in enumerate(PKU_vidvrd_categories)}
PKU_vidvrd_CatName2Id = {cat:idx for idx,cat in enumerate(PKU_vidvrd_categories)}

vidvrd_pred_categories = ["__background__",
    "taller","swim_behind","walk_away","fly_behind","creep_behind",
    "lie_with","move_left","stand_next_to","touch","follow",
    "move_away","lie_next_to","walk_with","move_next_to","creep_above",
    "stand_above","fall_off","run_with","swim_front","walk_next_to",
    "kick","stand_left","creep_right","sit_above","watch",
    "swim_with","fly_away","creep_beneath","front","run_past",
    "jump_right","fly_toward","stop_beneath","stand_inside","creep_left",
    "run_next_to","beneath","stop_left","right","jump_front",
    "jump_beneath","past","jump_toward","sit_front","sit_inside",
    "walk_beneath","run_away","stop_right","run_above","walk_right",
    "away","move_right","fly_right","behind","sit_right",
    "above","run_front","run_toward","jump_past","stand_with",
    "sit_left","jump_above","move_with","swim_beneath","stand_behind",
    "larger","walk_past","stop_front","run_right","creep_away",
    "move_toward","feed","run_left","lie_beneath","fly_front",
    "walk_behind","stand_beneath","fly_above","bite","fly_next_to",
    "stop_next_to","fight","walk_above","jump_behind","fly_with",
    "sit_beneath","sit_next_to","jump_next_to","run_behind","move_behind",
    "swim_right","swim_next_to","hold","move_past","pull",
    "stand_front","walk_left","lie_above","ride","next_to",
    "move_beneath","lie_behind","toward","jump_left","stop_above",
    "creep_toward","lie_left","fly_left","stop_with","walk_toward",
    "stand_right","chase","creep_next_to","fly_past","move_front",
    "run_beneath","creep_front","creep_past","play","lie_inside",
    "stop_behind","move_above","sit_behind","faster","lie_right",
    "walk_front","drive","swim_left","jump_away","jump_with",
    "lie_front","left"
]

vidvrd_PredId2name = {idx:cat for idx,cat in enumerate(vidvrd_pred_categories)}
vidvrd_PredName2Id = {cat:idx for idx,cat in enumerate(vidvrd_pred_categories)}


vidor_categories = [
    {'supercategory': 'vidor', 'id': 0, 'name': '__background__'},
    {'supercategory': 'vidor', 'id': 1, 'name': 'bread'},
    {'supercategory': 'vidor', 'id': 2, 'name': 'cake'},
    {'supercategory': 'vidor', 'id': 3, 'name': 'dish'},
    {'supercategory': 'vidor', 'id': 4, 'name': 'fruits'},
    {'supercategory': 'vidor', 'id': 5, 'name': 'vegetables'},
    {'supercategory': 'vidor', 'id': 6, 'name': 'crab'},
    {'supercategory': 'vidor', 'id': 7, 'name': 'backpack'},
    {'supercategory': 'vidor', 'id': 8, 'name': 'camera'},
    {'supercategory': 'vidor', 'id': 9, 'name': 'cellphone'},
    {'supercategory': 'vidor', 'id': 10, 'name': 'handbag'},
    {'supercategory': 'vidor', 'id': 11, 'name': 'laptop'},
    {'supercategory': 'vidor', 'id': 12, 'name': 'suitcase'},
    {'supercategory': 'vidor', 'id': 13, 'name': 'ball/sports_ball'},
    {'supercategory': 'vidor', 'id': 14, 'name': 'bat'},
    {'supercategory': 'vidor', 'id': 15, 'name': 'frisbee'},
    {'supercategory': 'vidor', 'id': 16, 'name': 'racket'},
    {'supercategory': 'vidor', 'id': 17, 'name': 'skateboard'},
    {'supercategory': 'vidor', 'id': 18, 'name': 'ski'},
    {'supercategory': 'vidor', 'id': 19, 'name': 'snowboard'},
    {'supercategory': 'vidor', 'id': 20, 'name': 'surfboard'},
    {'supercategory': 'vidor', 'id': 21, 'name': 'toy'},
    {'supercategory': 'vidor', 'id': 22, 'name': 'baby_seat'},
    {'supercategory': 'vidor', 'id': 23, 'name': 'bottle'},
    {'supercategory': 'vidor', 'id': 24, 'name': 'chair'},
    {'supercategory': 'vidor', 'id': 25, 'name': 'cup'},
    {'supercategory': 'vidor', 'id': 26, 'name': 'electric_fan'},
    {'supercategory': 'vidor', 'id': 27, 'name': 'faucet'},
    {'supercategory': 'vidor', 'id': 28, 'name': 'microwave'},
    {'supercategory': 'vidor', 'id': 29, 'name': 'oven'},
    {'supercategory': 'vidor', 'id': 30, 'name': 'refrigerator'},
    {'supercategory': 'vidor', 'id': 31, 'name': 'screen/monitor'},
    {'supercategory': 'vidor', 'id': 32, 'name': 'sink'},
    {'supercategory': 'vidor', 'id': 33, 'name': 'sofa'},
    {'supercategory': 'vidor', 'id': 34, 'name': 'stool'},
    {'supercategory': 'vidor', 'id': 35, 'name': 'table'},
    {'supercategory': 'vidor', 'id': 36, 'name': 'toilet'},
    {'supercategory': 'vidor', 'id': 37, 'name': 'guitar'},
    {'supercategory': 'vidor', 'id': 38, 'name': 'piano'},
    {'supercategory': 'vidor', 'id': 39, 'name': 'baby_walker'},
    {'supercategory': 'vidor', 'id': 40, 'name': 'bench'},
    {'supercategory': 'vidor', 'id': 41, 'name': 'stop_sign'},
    {'supercategory': 'vidor', 'id': 42, 'name': 'traffic_light'},
    {'supercategory': 'vidor', 'id': 43, 'name': 'aircraft'},
    {'supercategory': 'vidor', 'id': 44, 'name': 'bicycle'},
    {'supercategory': 'vidor', 'id': 45, 'name': 'bus/truck'},
    {'supercategory': 'vidor', 'id': 46, 'name': 'car'},
    {'supercategory': 'vidor', 'id': 47, 'name': 'motorcycle'},
    {'supercategory': 'vidor', 'id': 48, 'name': 'scooter'},
    {'supercategory': 'vidor', 'id': 49, 'name': 'train'},
    {'supercategory': 'vidor', 'id': 50, 'name': 'watercraft'},
    {'supercategory': 'vidor', 'id': 51, 'name': 'bird'},
    {'supercategory': 'vidor', 'id': 52, 'name': 'chicken'},
    {'supercategory': 'vidor', 'id': 53, 'name': 'duck'},
    {'supercategory': 'vidor', 'id': 54, 'name': 'penguin'},
    {'supercategory': 'vidor', 'id': 55, 'name': 'fish'},
    {'supercategory': 'vidor', 'id': 56, 'name': 'stingray'},
    {'supercategory': 'vidor', 'id': 57, 'name': 'crocodile'},
    {'supercategory': 'vidor', 'id': 58, 'name': 'snake'},
    {'supercategory': 'vidor', 'id': 59, 'name': 'turtle'},
    {'supercategory': 'vidor', 'id': 60, 'name': 'antelope'},
    {'supercategory': 'vidor', 'id': 61, 'name': 'bear'},
    {'supercategory': 'vidor', 'id': 62, 'name': 'camel'},
    {'supercategory': 'vidor', 'id': 63, 'name': 'cat'},
    {'supercategory': 'vidor', 'id': 64, 'name': 'cattle/cow'},
    {'supercategory': 'vidor', 'id': 65, 'name': 'dog'},
    {'supercategory': 'vidor', 'id': 66, 'name': 'elephant'},
    {'supercategory': 'vidor', 'id': 67, 'name': 'hamster/rat'},
    {'supercategory': 'vidor', 'id': 68, 'name': 'horse'},
    {'supercategory': 'vidor', 'id': 69, 'name': 'kangaroo'},
    {'supercategory': 'vidor', 'id': 70, 'name': 'leopard'},
    {'supercategory': 'vidor', 'id': 71, 'name': 'lion'},
    {'supercategory': 'vidor', 'id': 72, 'name': 'panda'},
    {'supercategory': 'vidor', 'id': 73, 'name': 'pig'},
    {'supercategory': 'vidor', 'id': 74, 'name': 'rabbit'},
    {'supercategory': 'vidor', 'id': 75, 'name': 'sheep/goat'},
    {'supercategory': 'vidor', 'id': 76, 'name': 'squirrel'},
    {'supercategory': 'vidor', 'id': 77, 'name': 'tiger'},
    {'supercategory': 'vidor', 'id': 78, 'name': 'adult'},
    {'supercategory': 'vidor', 'id': 79, 'name': 'baby'},
    {'supercategory': 'vidor', 'id': 80, 'name': 'child'}
]

vidor_pred_categories = [
    "__background__",
    "bite",
    "caress",
    "carry",
    "chase",
    "clean",
    "close",
    "cut",
    "drive",
    "feed",
    "get_off",
    "get_on",
    "grab",
    "hit",
    "hold",
    "hold_hand_of",
    "hug",
    "kick",
    "kiss",
    "knock",
    "lean_on",
    "lick",
    "lift",
    "open",
    "pat",
    "play(instrument)",
    "point_to",
    "press",
    "pull",
    "push",
    "release",
    "ride",
    "shake_hand_with",
    "shout_at",
    "smell",
    "speak_to",
    "squeeze",
    "throw",
    "touch",
    "use",
    "watch",
    "wave",
    "wave_hand_to",
    "above",
    "away",
    "behind",
    "beneath",
    "in_front_of",
    "inside",
    "next_to",
    "towards",
]

vidor_CatId2name = {v["id"]:v["name"] for v in vidor_categories}
vidor_CatName2Id = {v["name"]:v["id"] for v in vidor_categories}

vidor_PredId2name = {idx:cat for idx,cat in enumerate(vidor_pred_categories)}
vidor_PredName2Id = {cat:idx for idx,cat in enumerate(vidor_pred_categories)}

vidor_CatId2FG = {v["id"]:"FG" for v in vidor_categories}
vidor_PredId2FG= {idx:"FG" for idx,cat in enumerate(vidor_pred_categories)}

if __name__ == "__main__":
    
    print(len(vidor_categories))
    print(len(vidor_pred_categories))