import os
import shutil
import urllib
import zipfile
import tarfile
import gzip
import numpy as np
from PIL import Image

def prepare_drive_dataset():

    # Make the data folder if it doesn't exist
    if not os.path.exists('data'):
        os.mkdir('data')

    # Delete the folder if it already exists
    if os.path.exists('data/drive_dataset'):
        shutil.rmtree('data/drive_dataset')

    # Download the dataset
    os.mkdir('data/drive_dataset')
    _, _ = urllib.request.urlretrieve('http://webeye.ophth.uiowa.edu/abramoff/AV_groundTruth.zip', "data/drive_dataset/drive.zip")

    # Extract the dataset
    os.mkdir('data/drive_dataset/temp')
    with zipfile.ZipFile('data/drive_dataset/drive.zip','r') as zip_ref:
        zip_ref.extractall('data/drive_dataset/temp')
    os.remove('data/drive_dataset/drive.zip')

    # Arrange the dataset
    os.mkdir('data/drive_dataset/images')
    os.mkdir('data/drive_dataset/masks')

    c = 0
    for i in sorted(os.listdir('data/drive_dataset/temp/AV_groundTruth/training/images')):
        input_img_file = 'data/drive_dataset/temp/AV_groundTruth/training/images/'+i
        input_msk_file = 'data/drive_dataset/temp/AV_groundTruth/training/vessel/'+ i[:-4] + '.png'
        output_img_file = f'data/drive_dataset/images/{c:03}.tif'
        output_msk_file = f'data/drive_dataset/masks/{c:03}.png'
        img = Image.open(input_img_file)
        img.save(output_img_file)
        msk = Image.open(input_msk_file)
        msk.save(output_msk_file)
        c+=1
    for i in sorted(os.listdir('data/drive_dataset/temp/AV_groundTruth/test/images')):
        input_img_file = 'data/drive_dataset/temp/AV_groundTruth/test/images/'+i
        input_msk_file = 'data/drive_dataset/temp/AV_groundTruth/test/vessel/'+ i[:-4] + '.png'
        output_img_file = f'data/drive_dataset/images/{c:03}.tif'
        output_msk_file = f'data/drive_dataset/masks/{c:03}.png'
        img = Image.open(input_img_file)
        img.save(output_img_file)
        msk = Image.open(input_msk_file)
        msk.save(output_msk_file)
        c+=1

    # Delete unnecessary files
    shutil.rmtree('data/drive_dataset/temp')

    print('Drive dataset prepared')

#-------------------------------------------------------------------------------

def prepare_chase_dataset():

    # Make the data folder if it doesn't exist
    if not os.path.exists('data'):
        os.mkdir('data')

    # Delete the folder if it already exists
    if os.path.exists('data/chase_dataset'):
        shutil.rmtree('data/chase_dataset')

    # Download the dataset
    os.mkdir('data/chase_dataset')
    _, _ = urllib.request.urlretrieve('https://staffnet.kingston.ac.uk/~ku15565/CHASE_DB1/assets/CHASEDB1.zip', "data/chase_dataset/chase.zip")

    # Extract the dataset
    os.mkdir('data/chase_dataset/temp')
    with zipfile.ZipFile('data/chase_dataset/chase.zip','r') as zip_ref:
        zip_ref.extractall('data/chase_dataset/temp')
    os.remove('data/chase_dataset/chase.zip')

    # Arrange the dataset
    os.mkdir('data/chase_dataset/images')
    os.mkdir('data/chase_dataset/masks')

    c = 0
    for i in sorted(os.listdir('data/chase_dataset/temp')):
        if i[-3:] == 'jpg':
            input_img_file = 'data/chase_dataset/temp/'+i
            input_msk_file = 'data/chase_dataset/temp/'+ i[:-4] + '_1stHO.png'
            output_img_file = f'data/chase_dataset/images/{c:03}.jpg'
            output_msk_file = f'data/chase_dataset/masks/{c:03}.png'
            img = Image.open(input_img_file)
            img.save(output_img_file)
            msk = Image.open(input_msk_file)
            msk.save(output_msk_file)
            c+=1

    # Delete unnecessary files
    shutil.rmtree('data/chase_dataset/temp')

    print('Chase dataset prepared')

#-------------------------------------------------------------------------------

def prepare_stare_dataset():

    # Make the data folder if it doesn't exist
    if not os.path.exists('data'):
        os.mkdir('data')

    # Delete the folder if it already exists
    if os.path.exists('data/stare_dataset'):
        shutil.rmtree('data/stare_dataset')

    # Download the dataset
    os.mkdir('data/stare_dataset')
    _, _ = urllib.request.urlretrieve('https://cecas.clemson.edu/~ahoover/stare/probing/stare-images.tar', "data/stare_dataset/stare_images.tar")
    _, _ = urllib.request.urlretrieve('https://cecas.clemson.edu/~ahoover/stare/probing/labels-ah.tar', "data/stare_dataset/stare_labels.tar")

    # Extract the dataset
    os.mkdir('data/stare_dataset/temp')
    with tarfile.TarFile('data/stare_dataset/stare_images.tar','r') as tar_ref:
        tar_ref.extractall('data/stare_dataset/temp')
    os.remove('data/stare_dataset/stare_images.tar')
    with tarfile.TarFile('data/stare_dataset/stare_labels.tar','r') as tar_ref:
        tar_ref.extractall('data/stare_dataset/temp')
    os.remove('data/stare_dataset/stare_labels.tar')

    for i in os.listdir('data/stare_dataset/temp'):
        input_file_name = 'data/stare_dataset/temp/'+i
        output_file_name = 'data/stare_dataset/temp/'+i[:-3]
        with gzip.GzipFile(input_file_name, 'rb') as input:
            s = input.read()
        with open(output_file_name, 'wb') as output:
            output.write(s)
        os.remove(input_file_name)

    # Arrange the dataset
    os.mkdir('data/stare_dataset/images')
    os.mkdir('data/stare_dataset/masks')

    c = 0
    for i in sorted(os.listdir('data/stare_dataset/temp')):
        if i.split('.')[1] == 'ppm':
            input_img_file = 'data/stare_dataset/temp/'+i
            input_msk_file = 'data/stare_dataset/temp/'+ i[:-4] + '.ah.ppm'
            output_img_file = f'data/stare_dataset/images/{c:03}.ppm'
            output_msk_file = f'data/stare_dataset/masks/{c:03}.ppm'
            img = Image.open(input_img_file)
            img.save(output_img_file)
            msk = Image.open(input_msk_file)
            msk.save(output_msk_file)
            c+=1

    # Delete unnecessary files
    shutil.rmtree('data/stare_dataset/temp')

    print('Stare dataset prepared')
