import cv2
import numpy as np
from PIL import Image
from albumentations import CLAHE

def read_img(file_path, shape):
    img = Image.open(file_path)
    img = img.resize(shape)
    return np.array(img)

def read_msk(file_path, shape):
    img = Image.open(file_path).convert('L')
    img = img.resize(shape)
    return np.array(img)

def enhance_image_v1(image):
    processed_image = image.copy()
    processed_image = CLAHE(always_apply=True, p=1.0)(image=processed_image)['image']
    return processed_image

def enhance_image_v2(image):
    processed_image = image.copy()
    processed_image = cv2.addWeighted(processed_image,4,cv2.GaussianBlur(processed_image,(0,0),10),-4,128)
    return processed_image

def enhance_image_v3(image):
    processed_image = image.copy()
    processed_image1 = CLAHE(always_apply=True, p=1.0)(image=processed_image)['image']
    processed_image2 = cv2.addWeighted(processed_image1,4,cv2.GaussianBlur(processed_image1,(0,0),10),-4,128)
    processed_image = np.dstack([processed_image1, processed_image2])
    return processed_image
