import tensorflow as tf

def dice_loss(y_true, y_pred):
    intersection = tf.math.reduce_sum(y_true * y_pred)
    dice_score = (2. * intersection + 1.0) / (tf.math.reduce_sum(y_true) + tf.math.reduce_sum(y_pred) + 1.0)
    dice_loss = 1.0 - dice_score
    return dice_loss

def bce_dice_loss(y_true, y_pred):
    return tf.keras.losses.binary_crossentropy(y_true, y_pred) + dice_loss(y_true, y_pred)
