import tensorflow as tf

def iou(y_true, y_pred):
    y_true = tf.cast(y_true > 0.5, tf.float32)
    y_pred = tf.cast(y_pred > 0.5, tf.float32)
    intersection = tf.math.reduce_sum(y_true * y_pred)
    union = tf.math.reduce_sum(y_true) + tf.math.reduce_sum(y_pred) - intersection
    iou = (intersection + 1.0) / (union + 1.0)
    return iou
