import json
import argparse
from trainer import train
import warnings
from joint_training import joint_training
from eval_sensitive import eval_sensitive
from eval_esncp import eval_esncp
from plot_loss_density import plot_loss_density
from train_real_TAP import train_real_TAP
from train_TAP import train_TAP
from eval_cp import eval_cp
from retrain_esn_usingcp import retrain_esn_usingcp
from retrain_allesn_usingcp import retrain_allesn_usingcp
from eval_TIIcp import eval_TIIcp

warnings.filterwarnings("ignore")
def main():
    args = setup_parser().parse_args()
    param = load_json(args.config)
    args = vars(args)  # Converting argparse Namespace to a dict.
    args.update(param)
    # train(args)
    # joint_training(args)
    # eval_esncp(args)
    # train_TAP(args)
    eval_esncp(args)
    # train_real_TAP(args)
    # eval_cp(args)
    # retrain_esn_usingcp(args)
    # retrain_allesn_usingcp(args)
    # plot_loss_density(args)
def load_json(settings_path):
    with open(settings_path) as data_file:
        param = json.load(data_file)
    return param

def setup_parser():
    parser = argparse.ArgumentParser()
    parser.add_argument('--dataset', type=str, default='cifar100_vit',help="imagenetr , domainnet or cifar100_vit")
    parser.add_argument('--config', type=str, default='./exps/cifar100_vit.json',
                        help='Json file of settings.')
    parser.add_argument('--topk', type=int, default=5)
    return parser


if __name__ == '__main__':
    main()
