Continual Learning After Model Deployment
=====================================
This is a PyTorch implementation of the OpenLD algorithm.

This project is forked from https://github.com/tyler-hayes/Deep_SLDA

## Dependencies 
- Tested with Python 3.8.10 and PyTorch 1.12.1+cu113, NumPy, NVIDIA GPU


## Pretrained Model
Please download the pre-trained model from https://drive.google.com/file/d/1uEpqe6xo--8jdpOgR_YX3JqTHqj34oX6/view?usp=sharing, 
and set "--pretrained_model_path" argument in shell scripts. Default path is the project_directory.

## Usage
To replicate the experiments on different datasets, run the corresponding shell script from terminal:
- `openLD_cifar10.sh`
- `openLD_cifar100.sh`
- `openLD_tinyimagenet.sh`

To diversify the experiments and get results for different settings and OOD methods, you can change the arguments. Those arguments are:
- --experimental_setting  -> choices are ["random", "cil"]
- --ood_method            -> choices are ["rmd", "md", "mean"]
- --ood_threshold             -> set any float value for the selected OOD detection method (For the results in the paper, it should be set to 0, 0.07 and 0.08 for rmd, md and mean, respectively.)
- --cl_threshold             -> set any float value for well-learned class threshold (For the results in the paper, it should be set to 0.1)
