function [p_k, rec_k, ndcg_k] = prediction_evaluation_k(scores, labels, k)

%%% INPUT %%%
% scores - numerical scores for the samples
% labels - binary labels indicating the positive and negative samples

%%% OUTPUT %%%
% p-k    - average precision@k 
% rec-k  - average recall@k
% ndcg-k - average ndcg@k

p_k = -1;
rec_k = -1;
ndcg_k = -1;

num_users = size(scores, 1);
precisions = zeros(num_users, 1);
recalls = zeros(num_users, 1);
ndcgs = zeros(num_users, 1);
num_valid_user = 0;
for user = 1:num_users
    user_scores = scores(user, :);
    user_labels = labels(user, :);
    if size(user_scores, 2) < k
        return
    end

    [~, sorted_indices] = sort(user_scores, 'descend');
    top_k_indices = sorted_indices(1:k);
    true_relevance = user_labels(top_k_indices);
    true_positives = sum(true_relevance);

    
    if sum(user_labels) == 0
        recalls(user) = 0;
        precisions(user) = 0;
        ndcgs(user) = 0;
    else
        recalls(user) = true_positives / sum(user_labels);
        precisions(user) = true_positives / k;
        num_valid_user = num_valid_user + 1;
        ideal_relevance = sort(user_labels, 'descend');
        ideal_relevance = ideal_relevance(1:k);
        dcg = sum(true_relevance ./ log2((1:k)+1));
        idcg = sum(ideal_relevance ./ log2((1:k)+1));
        if idcg ~= 0
            ndcgs(user) = dcg / idcg;
        else
            ndcgs(user) = 0;
        end
    end
end

p_k = sum(precisions)/num_valid_user;
rec_k = sum(recalls) / num_valid_user;
ndcg_k = sum(ndcgs)/num_valid_user;