# AutoGPT + Docker guide

!!! important
    Docker Compose version 1.29.0 or later is required to use version 3.9 of the Compose file format.
    You can check the version of Docker Compose installed on your system by running the following command:

    ```shell
    docker compose version
    ```

    This will display the version of Docker Compose that is currently installed on your system.

    If you need to upgrade Docker Compose to a newer version, you can follow the installation instructions in the Docker documentation: XXXX

## Basic Setup

1. Make sure you have Docker installed, see [requirements](#requirements)
2. Create a project directory for AutoGPT

    ```shell
    mkdir AutoGPT
    cd AutoGPT
    ```

3. In the project directory, create a file called `docker-compose.yml`:

    <details>
    <summary>
      <code>docker-compose.yml></code> for <= v0.4.7
    </summary>

    ```yaml
    version: "3.9"
    services:
      auto-gpt:
        image: significantgravitas/auto-gpt
        env_file:
          - .env
        profiles: ["exclude-from-up"]
        volumes:
          - ./auto_gpt_workspace:/app/auto_gpt_workspace
          - ./data:/app/data
          ## allow auto-gpt to write logs to disk
          - ./logs:/app/logs
          ## uncomment following lines if you want to make use of these files
          ## you must have them existing in the same folder as this docker-compose.yml
          #- type: bind
          #  source: ./azure.yaml
          #  target: /app/azure.yaml
    ```
    </details>

    <details>
    <summary>
      <code>docker-compose.yml></code> for > v0.4.7 (including <code>master</code>)
    </summary>

    ```yaml
    version: "3.9"
    services:
      auto-gpt:
        image: significantgravitas/auto-gpt
        env_file:
          - .env
        ports:
          - "8000:8000"  # remove this if you just want to run a single agent in TTY mode
        profiles: ["exclude-from-up"]
        volumes:
          - ./data:/app/data
          ## allow auto-gpt to write logs to disk
          - ./logs:/app/logs
          ## uncomment following lines if you want to make use of these files
          ## you must have them existing in the same folder as this docker-compose.yml
    ```
    </details>


4. Download [`.env.template`][.env.template] and save it as `.env` in the AutoGPT folder.
5. Follow the standard [configuration instructions](../index.md#completing-the-setup),
   from step 3 onwards and excluding `poetry install` steps.
6. Pull the latest image from [Docker Hub]

    ```shell
    docker pull significantgravitas/auto-gpt
    ```

!!! note "Docker only supports headless browsing"
    AutoGPT uses a browser in headless mode by default: `HEADLESS_BROWSER=True`.
    Please do not change this setting in combination with Docker, or AutoGPT will crash.

[.env.template]: XXXX
[Docker Hub]: XXXX

## Developer Setup

!!! tip
    Use this setup if you have cloned the repository and have made (or want to make)
    changes to the codebase.

1. Copy `.env.template` to `.env`.
2. Follow the standard [configuration instructions](../index.md#completing-the-setup),
   from step 3 onwards and excluding `poetry install` steps.

## Running AutoGPT with Docker

After following setup instructions above, you can run AutoGPT with the following command:

```shell
docker compose run --rm auto-gpt
```

This creates and starts an AutoGPT container, and removes it after the application stops.
This does not mean your data will be lost: data generated by the application is stored
in the `data` folder.

Subcommands and arguments work the same as described in the [user guide]:

* Run AutoGPT:
    ```shell
    docker compose run --rm auto-gpt serve
    ```
* Run AutoGPT in TTY mode, with continuous mode.
    ```shell
    docker compose run --rm auto-gpt run --continuous
    ```
* Run AutoGPT in TTY mode and install dependencies for all active plugins:
    ```shell
    docker compose run --rm auto-gpt run --install-plugin-deps
    ```

If you dare, you can also build and run it with "vanilla" docker commands:

```shell
docker build -t autogpt .
docker run -it --env-file=.env -v $PWD:/app autogpt
docker run -it --env-file=.env -v $PWD:/app --rm autogpt --gpt3only --continuous
```

[user guide]: ../usage.md/#command-line-interface
