import logging


class BelowLevelFilter(logging.Filter):
    """Filter for logging levels below a certain threshold."""

    def __init__(self, below_level: int):
        super().__init__()
        self.below_level = below_level

    def filter(self, record: logging.LogRecord):
        return record.levelno < self.below_level
