import numpy as np
import pandas as pd
import os
from scipy.stats import bernoulli
np.random.seed(2)

data_name = 'ACIC'
data_columns = {
    'IHDP':25,
    'ACIC':82
}
def data_generate(path):

    saved_path = '/'.join(path.strip().split('/')[:-2])
    saved_path = saved_path + '/' + data_name
    for i in range(1,101):
        read_path = os.path.join(path, f'{data_name}{i}.csv')
        df = pd.read_csv(read_path)

        x_columns = [f'x{index}' for index in range(1,data_columns[data_name]+1)]
        raw_data = df[x_columns].to_numpy()

        for index,raw_line in enumerate(raw_data):
            scale_x = 0.7 ** 2 * raw_line + 0.3 ** 2 * (1 - raw_line)
            if sum(scale_x) < 0:
                x = np.random.normal(loc=raw_line, scale=1, size=len(raw_line))
            else:
                x = np.random.normal(loc=raw_line, scale=sum(scale_x), size=len(raw_line))
            raw_data[index] = x

        df[x_columns] = raw_data
        saved_path_file = saved_path + f'/{data_name}{i}.csv'
        df.to_csv(saved_path_file, index=False)


def sigmoid(x):
    return 1. / (1. + np.exp(-x))

if __name__ == "__main__":
    curPath = os.path.abspath(os.path.dirname(__file__))
    rootPath = curPath[:curPath.find('DFHTE') + len('DFHTE')]
    data_path = os.path.join(rootPath,'dataset/resource')
    path = os.path.join(data_path,data_name)
    data_generate(path)
