# Two Is Better Than One: Aligned Representation Pairs for Anomaly Detection

This repository contains the code for the paper *Two Is Better Than One: Aligned Representation Pairs for Anomaly Detection*.

If you would like to run our code, there are a few steps to take:

1) set up a virtual environment using the dependencies in `requirements.txt`
2) download the datasets you want to evaluate on
3) run our code as follows:
```
python main.py  --config-path=configs/context_contrasting \
                --config-name=<dataset>_ad_config \
                loss.augmentation_class=<context_aug> \
                ++dataset.normal_class=<normal_class> \
                ++dataset.data_path=<dataset_path>
```
The following options are available to run the code:
- `<dataset>` should be one of `breast_mnist`, `octmnist`, `kvasir`, `br35h`, `melanoma`, `pneumonia`, `cifar10`, `cifar100`, `imagenet30`, `dogs_vs_cats`, or `muffin_vs_chihuahua`.
- `<context_aug>` should be one of `random_invert`, `random_flip`, or `random_equalize`.
- `<normal_class>` should be an integer corresponding to which class of the dataset should be set to normal. For `breast_mnist`, `octmnist`, `kvasir`, `br35h`, `melanoma`, and `pneumonia`, `0` corresponds to the healthy index.
- `<dataset_path>` should be the root directory of `<dataset>`.

More config options can be found in `./configs/*.py`, particularly regarding logging (`./configs/logging.py`), various augmentation options (`./configs/augmentations.py`), or optimizer settings `./configs/optimizer.py`
All datasets can be dowloaded from publicly available sources (see appendix of the paper).

