from enum import Enum, IntEnum

from utils.losses import *


class ResNetType(IntEnum):
    resnet18 = 18
    resnet34 = 34
    resnet50 = 50
    resnet101 = 101
    resnet152 = 152


class AnomalyLoss(Enum):
    context_contrasting_loss = "context_contrasting_loss"

    def get_loss(self, *args, **kwargs):
        return ContextContrastingLoss(*args, **kwargs)

    def inference_types(self):
        return [
            AnomalyScore.nearest_cosine_neighbor,
            AnomalyScore.context_likelihood,
        ]


class AnomalyScore(Enum):
    nearest_cosine_neighbor = "nearest_cosine_neighbor"
    context_likelihood = "context_likelihood"
